<!DOCTYPE html>
<html lang="bn">
<head>
    <title>My Wallet</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root { --primary-color: #6a00f4; --bg-color: #f0f1f6; --card-bg: white; --success: #4CAF50; --error: #F44336; }
        body { font-family: 'Roboto', sans-serif; background-color: var(--bg-color); margin: 0; padding: 15px; padding-bottom: 85px; }
        .balance-card { background: linear-gradient(135deg, #7b2cbf, #9d4edd); color: white; padding: 25px; border-radius: 20px; text-align: center; margin-bottom: 20px; box-shadow: 0 10px 25px rgba(123, 44, 191, 0.3); }
        .balance-card h4 { margin: 0 0 10px; font-size: 1em; opacity: 0.8; text-transform: uppercase; }
        .balance-card .amount { font-size: 2.5em; font-weight: 700; margin: 0; }
        .balance-card .sub-balance { font-size: 0.9em; opacity: 0.9; margin-top: 10px; }
        .actions { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; margin-bottom: 25px; }
        .action-btn { background-color: var(--card-bg); padding: 12px 5px; border-radius: 12px; text-align: center; border: none; font-size: 0.9em; font-weight: 500; cursor: pointer; box-shadow: 0 4px 15px rgba(0,0,0,0.05); transition: transform 0.2s; }
        .action-btn:active { transform: scale(0.95); }
        .action-btn i { font-size: 20px; margin-bottom: 8px; display: block; }
        .history-section h3 { margin-bottom: 15px; }
        .txn-item { display: flex; justify-content: space-between; align-items: center; background-color: var(--card-bg); padding: 15px; border-radius: 10px; margin-bottom: 10px; }
        .txn-details p { margin: 0; }
        .txn-amount { font-weight: 500; font-size: 1.1em; }
        .txn-amount.deposit { color: #388e3c; } .txn-amount.withdraw { color: #d32f2f; }
        .txn-status-wrapper { text-align: right; }
        .txn-status { font-size: 0.8em; font-weight: 500; text-transform: uppercase; padding: 3px 8px; border-radius: 20px; color: white; display: inline-block; margin-top: 4px; }
        .txn-status.pending { background-color: #f57c00; } .txn-status.complete, .txn-status.completed { background-color: #388e3c; } .txn-status.failed, .txn-status.rejected { background-color: #d32f2f; }
        .modal { display: none; position: fixed; z-index: 2000; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.6); animation: fadeIn 0.3s; justify-content: center; align-items: flex-end; }
        .modal-content { width: 100%; background-color: var(--bg-color); border-top-left-radius: 20px; border-top-right-radius: 20px; padding: 20px; padding-bottom: 30px; box-sizing: border-box; animation: slideUp 0.3s; max-height: 90vh; overflow-y: auto; }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .modal-header h2 { margin: 0; }
        .close { font-size: 28px; font-weight: bold; cursor: pointer; color: #888; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; }
        .form-group input, .form-group select { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; font-size: 1em; }
        .modal-btn { width: 100%; padding: 15px; border: none; border-radius: 10px; background: var(--primary-color); color: white; font-size: 18px; font-weight: 700; cursor: pointer; transition: background-color 0.2s; }
        .payment-info { background-color: #e8eaf6; padding: 10px; border-radius: 8px; text-align: center; margin-bottom: 15px; }
        .payment-info strong { font-size: 1.2em; color: var(--primary-color); }
        .info-msg { padding: 10px; text-align: center; background: #fffde7; border-radius: 8px; margin-top: 15px; }
        .animation-overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 3000; justify-content: center; align-items: center; }
        .animation-container { text-align: center; }
        .circle-loader { margin: 0 auto 15px; border: 4px solid rgba(255, 255, 255, 0.2); border-left-color: #ffffff; border-radius: 50%; width: 80px; height: 80px; animation: spin 1s linear infinite; }
        .checkmark-loader { border-color: rgba(122, 193, 66, 0.3); border-left-color: #7ac142; }
        .cross-loader { border-color: rgba(244, 67, 54, 0.3); border-left-color: #F44336; }
        .animation-message { font-size: 1.4em; font-weight: bold; color: white; margin-top: 20px; }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        @keyframes slideUp { from { transform: translateY(100%); } to { transform: translateY(0); } }
        @keyframes spin { 100% { transform: rotate(360deg); } }
    </style>
</head>
<body>

    <div class="balance-card">
        <h4>TOTAL BALANCE</h4>
        <h1 class="amount">৳<?php echo e(number_format($user->Balance ?? 0, 2)); ?></h1>
        <p class="sub-balance">Winning Balance: ৳<?php echo e(number_format($user->Winning ?? 0, 2)); ?></p>
    </div>

    <div class="actions">
        <button class="action-btn" onclick="openModal('addMoneyModal')"><i class="fas fa-plus-circle" style="color:var(--success)"></i> Add Money</button>
        <button class="action-btn" onclick="openModal('withdrawModal')"><i class="fas fa-arrow-circle-up" style="color:var(--error)"></i> Withdraw</button>
        <button class="action-btn" onclick="openModal('transferModal')"><i class="fas fa-exchange-alt" style="color:#2196F3"></i> Transfer</button>
    </div>

    <div class="history-section">
        <h3>Recent Transactions</h3>
        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $txn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="txn-item">
                <div class="txn-details">
                    <p><strong><?php echo e($txn->type); ?></strong> - <small><?php echo e($txn->Method); ?></small></p>
                    <p style="font-size: 0.8em; color: #666;">
                        <?php echo e(\Carbon\Carbon::parse($txn->Date)->format('d M Y, h:i A')); ?>

                    </p>
                </div>
                <div class="txn-status-wrapper">
                    <div class="txn-amount <?php echo e(strtolower($txn->type)); ?>">
                        <?php echo e($txn->type == 'Deposit' ? '+' : '-'); ?>৳<?php echo e(number_format((float)$txn->Amount, 2)); ?>

                    </div>
                    <div class="txn-status <?php echo e(strtolower($txn->Status)); ?>">
                        <?php echo e($txn->Status); ?>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p style="text-align:center; color:#888;">No transactions yet.</p>
        <?php endif; ?>
    </div>
    
    <!-- Modals -->
    <div id="addMoneyModal" class="modal"><div class="modal-content"><div class="modal-header"><h2>Add Money</h2><span class="close" onclick="closeModal('addMoneyModal')">×</span></div><form method="POST" action="<?php echo e(route('wallet.transaction')); ?>"><input type="hidden" name="action" value="add_money"><?php echo csrf_field(); ?><div class="form-group"><label>Select Method</label><select id="add_method" name="method" onchange="updatePaymentInfo()"><option value="bKash">bKash</option><option value="Nagad">Nagad</option><option value="Rocket">Rocket</option></select></div><div class="payment-info">Send money to: <strong id="paymentNumberDisplay"></strong></div>
    <div class="form-group"><label>Amount</label><input type="number" step="0.01" name="amount" placeholder="Minimum ৳<?php echo e(number_format((float)($adminSettings->{'Minimum Deposit'} ?? 0), 2)); ?>" required></div>
    <div class="form-group"><label>Transaction ID</label><input type="text" name="transaction_id" placeholder="Enter the transaction ID from SMS" required></div>
    <button type="submit" class="modal-btn"><?php echo e(($adminSettings->Payment_Mode ?? 'Manual') == 'Manual' ? 'Submit Request' : 'Verify Payment'); ?></button></form></div></div>
    <div id="withdrawModal" class="modal"><div class="modal-content"><div class="modal-header"><h2>Withdraw Money</h2><span class="close" onclick="closeModal('withdrawModal')">×</span></div><form method="POST" action="<?php echo e(route('wallet.transaction')); ?>"><input type="hidden" name="action" value="withdraw"><?php echo csrf_field(); ?><div class="form-group"><label>Withdraw To</label><select name="method"><option value="bKash">bKash</option><option value="Nagad">Nagad</option><option value="Rocket">Rocket</option></select></div><div class="form-group"><label>Amount</label><input type="number" step="0.01" name="amount" placeholder="Minimum ৳<?php echo e(number_format((float)($adminSettings->{'Minimum Withdraw'} ?? 0), 2)); ?>" max="<?php echo e((float)($user->Winning ?? 0)); ?>" required></div><div class="form-group"><label>Your Account Number</label><input type="text" name="account_no" placeholder="Enter Bkash/Nagad/Rocket number" required></div><p class="info-msg">Note: You can only withdraw from your <strong>Winning Balance</strong>.</p><button type="submit" class="modal-btn">Submit Withdraw</button></form></div></div>
    <div id="transferModal" class="modal"><div class="modal-content"><div class="modal-header"><h2>Transfer to Main Balance</h2><span class="close" onclick="closeModal('transferModal')">×</span></div><form method="POST" action="<?php echo e(route('wallet.transaction')); ?>"><input type="hidden" name="action" value="transfer_balance"><?php echo csrf_field(); ?><p style="text-align:center;">Your Winning Balance: <strong>৳<?php echo e(number_format($user->Winning ?? 0, 2)); ?></strong></p><div class="form-group"><label>Amount to Transfer</label><input type="number" step="0.01" name="amount" placeholder="Enter amount to transfer" required max="<?php echo e((float)($user->Winning ?? 0)); ?>"></div><p class="info-msg">The amount will be moved from winning balance to main balance.</p><button type="submit" class="modal-btn">Confirm Transfer</button></form></div></div>

    <!-- Status Animation Overlay -->
    <?php if(session('status_type') && session('status_message')): ?>
    <div id="status-animation" class="animation-overlay" style="display: flex;">
        <div class="animation-container">
            <div id="loader-icon"></div>
            <h2 id="animation-message" class="animation-message"></h2>
        </div>
    </div>
    <?php endif; ?>
    
    <?php echo $__env->make('partials.bottom-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        function openModal(id) { document.getElementById(id).style.display = 'flex'; }
        function closeModal(id) { document.getElementById(id).style.display = 'none'; }
        window.onclick = function(event) { if (event.target.classList.contains('modal')) closeModal(event.target.id); }
        
        const adminSettings = <?php echo json_encode($adminSettings ?? [], 15, 512) ?>;
        const paymentNumbers = { 
            'bKash': adminSettings['bKash Number'] || 'N/A', 
            'Nagad': adminSettings['Nagad Number'] || 'N/A', 
            'Rocket': adminSettings['Rocket Number'] || 'N/A' 
        };
        function updatePaymentInfo() { 
            const selectedMethod = document.getElementById('add_method').value; 
            document.getElementById('paymentNumberDisplay').innerText = paymentNumbers[selectedMethod] || 'Not Available'; 
        }
        document.addEventListener('DOMContentLoaded', updatePaymentInfo);

        function showStatusAnimation(status, message) {
            const overlay = document.getElementById('status-animation');
            const loaderIcon = document.getElementById('loader-icon');
            const messageEl = document.getElementById('animation-message');
            
            if (!overlay || !loaderIcon || !messageEl) return;

            messageEl.innerText = message;
            if(status === 'success') { 
                loaderIcon.innerHTML = `<div class="circle-loader checkmark-loader"></div>`; 
            } else { 
                loaderIcon.innerHTML = `<div class="circle-loader cross-loader"></div>`; 
            }
            overlay.style.display = 'flex';
            setTimeout(() => { 
                window.location.href = "<?php echo e(route('wallet.index')); ?>";
            }, 2500);
        }

        const formStatus = "<?php echo e(session('status_type')); ?>";
        const statusMessage = "<?php echo e(session('status_message')); ?>";

        if (formStatus && statusMessage) {
            showStatusAnimation(formStatus, statusMessage);
        }
    </script>
</body>
</html><?php /**PATH /storage/emulated/0/htdocs/resources/views/wallet.blade.php ENDPATH**/ ?>