
<div id="passwordModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Change Password</h2>
            <span class="close-btn" onclick="document.getElementById('passwordModal').classList.remove('is-visible');">×</span>
        </div>
        <div class="modal-body">
            
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>
            <?php if($errors->any() && session('from_password_change')): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.password.change')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label>Current Password</label>
                    <input type="password" name="current_password" required>
                </div>
                <div class="form-group">
                    <label>New Password</label>
                    <input type="password" name="new_password" required>
                </div>
                <div class="form-group">
                    <label>Confirm New Password</label>
                    <input type="password" name="new_password_confirmation" required>
                </div>
                <button type="submit" class="btn-action" style="width: 100%; background-color: var(--primary-color); color: white; justify-content: center; font-weight: 600;">
                    Update Password
                </button>
            </form>
        </div>
    </div>
</div><?php /**PATH /storage/emulated/0/htdocs/resources/views/admin/partials/password-modal.blade.php ENDPATH**/ ?>