<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Home - Khelo Bangladesh</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root { --primary-color: #6a00f4; --bg-color: #f7f8fc; --card-bg: #ffffff; --card-border-color: #e3e8f0; --section-title-color: #3f4a59; --card-title-color: #2c3e50; --card-subtitle-color: #7f8c8d; --fab-bg: linear-gradient(45deg, #FDC830, #F37335); }
        body { font-family: 'Roboto', sans-serif; background-color: var(--bg-color); margin: 0; padding-bottom: 85px; }
        .main-container { padding: 15px; }
        .slider-container { position: relative; width: 100%; aspect-ratio: 16 / 8; margin-bottom: 20px; border-radius: 15px; overflow: hidden; box-shadow: 0 8px 25px rgba(0,0,0,0.1); background-color: #ddd; }
        .view-pager { display: flex; height: 100%; transition: transform 0.5s ease-in-out; }
        .slide { min-width: 100%; height: 100%; }
        .slide a, .slide img { display: block; width: 100%; height: 100%; object-fit: cover; }
        .dots-container { position: absolute; bottom: 10px; left: 50%; transform: translateX(-50%); display: flex; z-index: 10; }
        .dot { height: 8px; width: 8px; margin: 0 5px; background-color: rgba(255,255,255,0.7); border-radius: 50%; cursor: pointer; }
        .dot.active { background-color: white; }
        .no-slider-message { display: flex; justify-content: center; align-items: center; height: 100%; color: #888; }
        .notice-bar { background-color: white; padding: 10px; border-radius: 8px; margin-bottom: 20px; display: flex; align-items: center; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .notice-icon { width: 20px; height: 20px; margin-right: 10px; }
        .marquee { white-space: nowrap; overflow: hidden; width: 100%; }
        .marquee span { display: inline-block; padding-left: 100%; animation: marquee 15s linear infinite; font-weight: 500; }
        @keyframes marquee { 0% { transform: translate(0, 0); } 100% { transform: translate(-100%, 0); } }
        .section-header { font-size: 1.2em; font-weight: 700; color: #3f4a59; margin: 15px 0; text-align: center; }
        .match-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 18px; }
        .game-card { background-color: #ffffff; border-radius: 16px; border: 2px solid #e3e8f0; overflow: hidden; text-decoration: none; color: #2c3e50; }
        .game-card .banner { width: 100%; aspect-ratio: 4 / 3; background-size: cover; background-position: center; }
        .game-card .info { padding: 12px; text-align: center; background-color: white; box-shadow: 0px -5px 15px -5px rgba(0,0,0,0.1); }
        .game-card .title { font-weight: 700; font-size: 1.1em; margin: 0; }
        .game-card .count { font-size: 0.85em; color: #7f8c8d; margin-top: 4px; }
        .fab { position: fixed; width: 56px; height: 56px; background: linear-gradient(45deg, #FDC830, #F37335); border-radius: 50%; bottom: 90px; right: 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 12px rgba(0,0,0,0.2); z-index: 999; text-decoration: none; }
        .fab i { font-size: 24px; color: white; }
    </style>
</head>
<body>
    <div class="main-container">
        <div class="slider-container">
            <?php if($sliders->isNotEmpty()): ?>
                <div class="view-pager" id="viewPager">
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="slide"><a href="<?php echo e($slide->link ?? '#'); ?>"><img src="<?php echo e($slide->img); ?>" alt="Promotional Banner"></a></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="dots-container" id="dotsContainer"></div>
            <?php else: ?>
                <div class="no-slider-message"><span>No Sliders Available</span></div>
            <?php endif; ?>
        </div>

        <div class="notice-bar">
            <img src="<?php echo e(asset('assets/images/notification_icon.png')); ?>" class="notice-icon" alt="Notice">
            <div class="marquee"><span><?php echo e($noticeText); ?></span></div>
        </div>

        <h2 class="section-header">ALL MATCHES</h2>
        <div class="match-grid">
            <a href="<?php echo e(route('matches.list', ['type' => 'br_match'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/br_banner.jpg')); ?>');"></div><div class="info"><p class="title">BR MATCH</p><p class="count"><?php echo e($gameCounts['br_match']); ?> Matches Found</p></div></a>
            <a href="<?php echo e(route('matches.list', ['type' => 'clash_squad'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/cs_banner.jpg')); ?>');"></div><div class="info"><p class="title">Clash Squad</p><p class="count"><?php echo e($gameCounts['clash_squad']); ?> Matches Found</p></div></a>
            <a href="<?php echo e(route('matches.list', ['type' => 'cs_2v2'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/cs_2v2_banner.jpg')); ?>');"></div><div class="info"><p class="title">CS 2 VS 2</p><p class="count"><?php echo e($gameCounts['cs_2v2']); ?> Matches Found</p></div></a>
            <a href="<?php echo e(route('matches.list', ['type' => 'lone_wolf'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/lone_wolf_banner.jpg')); ?>');"></div><div class="info"><p class="title">LONE WOLF</p><p class="count"><?php echo e($gameCounts['lone_wolf']); ?> Matches Found</p></div></a>
            <a href="<?php echo e(route('matches.list', ['type' => 'ludo'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/ludo_banner.jpg')); ?>');"></div><div class="info"><p class="title">Ludo</p><p class="count"><?php echo e($gameCounts['ludo']); ?> Matches Found</p></div></a>
            <a href="<?php echo e(route('matches.list', ['type' => 'free_match'])); ?>" class="game-card"><div class="banner" style="background-image: url('<?php echo e(asset('assets/images/free_match_banner.jpg')); ?>');"></div><div class="info"><p class="title">Free Match</p><p class="count"><?php echo e($gameCounts['free_match']); ?> Matches Found</p></div></a>
        </div>
    </div>
    
    <a href="<?php echo e($supportLink); ?>" class="fab" target="_blank"><i class="fas fa-headset"></i></a>
    
    <?php echo $__env->make('partials.bottom-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const viewPager = document.getElementById('viewPager');
            if (viewPager && viewPager.children.length > 0) {
                const dotsContainer = document.getElementById('dotsContainer');
                const slides = viewPager.querySelectorAll('.slide');
                let currentSlide = 0;
                dotsContainer.innerHTML = '';
                slides.forEach((_, index) => {
                    const dot = document.createElement('div');
                    dot.className = 'dot';
                    if (index === 0) dot.classList.add('active');
                    dot.addEventListener('click', () => goToSlide(index));
                    dotsContainer.appendChild(dot);
                });
                const dots = dotsContainer.querySelectorAll('.dot');
                const goToSlide = (index) => {
                    viewPager.style.transform = `translateX(-${index * 100}%)`;
                    currentSlide = index;
                    dots.forEach((dot, i) => dot.classList.toggle('active', i === currentSlide));
                };
                const nextSlide = () => {
                    const nextIndex = (currentSlide + 1) % slides.length;
                    goToSlide(nextIndex);
                };
                if (slides.length > 1) { setInterval(nextSlide, 4000); }
            }
        });
    </script>
</body>
</html><?php /**PATH /storage/emulated/0/htdocs/resources/views/home.blade.php ENDPATH**/ ?>